IF EXISTS (SELECT * FROM sys.columns WHERE name = 'CODIGO_IFOOD' AND object_id = OBJECT_ID('INTEGRA_IFOOD_PEDIDO_MANUAL'))
BEGIN
    DECLARE @pk_name SYSNAME;
    DECLARE @sql NVARCHAR(MAX);

    SELECT @pk_name = kc.name
    FROM sys.key_constraints kc
    WHERE kc.parent_object_id = OBJECT_ID('INTEGRA_IFOOD_PEDIDO_MANUAL')
      AND kc.type = 'PK';

    IF @pk_name IS NOT NULL
    BEGIN
        SET @sql = N'ALTER TABLE INTEGRA_IFOOD_PEDIDO_MANUAL DROP CONSTRAINT [' + @pk_name + N']';
        EXEC sp_executesql @sql;
    END;

    ALTER TABLE INTEGRA_IFOOD_PEDIDO_MANUAL
        ALTER COLUMN CODIGO_IFOOD VARCHAR(40) COLLATE SQL_Latin1_General_CP1_CI_AS NOT NULL;

    IF @pk_name IS NOT NULL
    BEGIN
        SET @sql = N'ALTER TABLE INTEGRA_IFOOD_PEDIDO_MANUAL ADD CONSTRAINT [' + @pk_name + N'] PRIMARY KEY (CODIGO_IFOOD)';
        EXEC sp_executesql @sql;
    END;
END;
